@echo off
@rem This script will install LANSA Hot Fix files
@rem it will create backup file(s) and will back itself out if the install is unsuccessful
@rem it assumes it is being called from a subdirectory under the LANSA root directory
@setlocal

@echo.
if not "%1" == "" goto :usage

set EPClvl=859
set minEPClvl=859
set BUDIR=bu101005
cd files
if errorlevel 1 goto :wrongDir

set LR=..\..
if not exist %LR%\lansa                   goto :invalidRoot
if not exist %LR%\lansa\XSLEditor         goto :invalidRoot
if not exist %LR%\x_win95\x_lansa         goto :invalidRoot
if not exist %LR%\x_win95\x_lansa\execute goto :invalidRoot
if not exist %LR%\x_win95\x_lansa\source  goto :invalidRoot

find "4042" %LR%\build.dat > NUL
if errorlevel 1 goto :wrongVersion

if "%EPClvl%" == "" goto :skipEPC
find "x%EPClvl%" %LR%\EPCCheck.dat > NUL
if not errorlevel 1 goto :wrongEPClevel

find "E%minEPClvl%" %LR%\EPCCheck.dat > NUL
if errorlevel 1 goto :wrongEPClevel
:skipEPC

@rem create/clean backup directories
for %%i in ( x_win95\x_lansa\execute x_win95\x_lansa\source lansa lansa\XSLEditor connect ) do (
  @echo create backup dir for %%i\%BUDIR%
  if not exist %LR%\%%i\%BUDIR% mkdir %LR%\%%i\%BUDIR%
  @rem clean out directory
  del /q %LR%\%%i\%BUDIR%\*
)

@rem dir /b /l files

for %%i in (le*)   do call :copyFile %%i %LR%\x_win95\x_lansa\execute
for %%i in (lh_*)   do call :copyFile %%i %LR%\x_win95\x_lansa\execute
for %%i in (lm_*)   do call :copyFile %%i %LR%\x_win95\x_lansa\execute
for %%i in (w3*)   do call :copyFile %%i %LR%\x_win95\x_lansa\execute
for %%i in (lp_*)  do call :copyFile %%i %LR%\x_win95\x_lansa\execute
for %%i in (lx*.dll)   do call :copyFile %%i %LR%\x_win95\x_lansa\execute
for %%i in (lx*.exe)   do call :copyFile %%i %LR%\x_win95\x_lansa\execute
for %%i in (x_*.dll)   do call :copyFile %%i %LR%\x_win95\x_lansa\execute
for %%i in (x_*.lib)   do call :copyFile %%i %LR%\x_win95\x_lansa\execute
for %%i in (x_*.exe)   do call :copyFile %%i %LR%\x_win95\x_lansa\execute
for %%i in (u_*)   do call :copyFile %%i %LR%\x_win95\x_lansa\execute
for %%i in (*.h)   do call :copyFile %%i %LR%\x_win95\x_lansa\source
for %%i in (*.s)   do call :copyFile %%i %LR%\x_win95\x_lansa\source
for %%i in (li*)   do call :copyFile %%i %LR%\lansa
for %%i in (lco*)  do call :copyFile %%i %LR%\connect
for %%i in (lansa*.exe)   do call :copyFile %%i %LR%\lansa
for %%i in (XSLEditorFrame*)   do call :copyFile %%i %LR%\lansa
for %%i in (*.bnd) do call :copyFile %%i %LR%\lansa
for %%i in (lxx*.asf) do call :copyFile %%i %LR%\x_win95\x_lansa\source
if exist settings.ini (
  if not exist %LR%\lansa\XSLEditor\settings.ini (
    call :copyFile settings.ini %LR%\lansa\XSLEditor
  ) else (
    if exist settingstimeout.ini (
      find "Timeout" %LR%\lansa\XSLEditor\settings.ini > NUL
      if errorlevel 1 type  settingstimeout.ini >> %LR%\lansa\XSLEditor\settings.ini
    )
  )
)

for %%i in (x_base.dll x_dom.dll x_prim.dll x_rom.dll x_cbv1.dll) do (
  if exist %%i        call :copyFile %%i %LR%\lansa
)

if exist XSLEditor (
  cd XSLEditor
  for %%i in (*)   do call :copyFile %%i ..\%LR%\lansa\XSLEditor
  cd ..
)

set IMP_DIR=STD_BIFS
if exist %IMP_DIR% (
  @echo patch %IMP_DIR% import
  @echo   Backup...
  xcopy %LR%\lansa\imports\%IMP_DIR% %LR%\lansa\imports\%IMP_DIR%.%BUDIR% /s /i /y
  @echo   Update...
  xcopy %IMP_DIR% %LR%\lansa\imports\%IMP_DIR% /s /i /y
)


@rem delete bnb files if any bnd files exist
if exist *.bnd del /q %LR%\lansa\*.bnb

@rem OK files now updated, lets update epc.dat to record the fact
@echo ---LANSA Hot Fix (%DATE%) >> %LR%\epc.dat
type ..\hotfix.dat             >> %LR%\epc.dat



goto :theEnd

:copyFile
  @echo copy %1 %2
  @rem first make backup after ensuring we have write access
  attrib -R %2\%1
  @echo   Backup...
  copy %2\%1 %2\%BUDIR%
  @echo   Update...
  copy %1 %2
  if ERRORLEVEL 1 goto :copyFailed
  goto :EOF

:copyFailed
  @echo copy failed - restore backup files
  for %%i in ( x_win95\x_lansa\execute lansa ) do copy %LR%\%%i\%BUDIR%\* %LR%\%%i
  echo restore complete.
  echo.
  echo This window will now close when you hit any key. You may [Ctrl-C] to exit script
  pause
  exit 1

:wrongDir
@echo ERROR: %0 has not been run from the Hot Fix directory
goto :exitError

:invalidRoot
@echo ERROR: parent directory is NOT a valid LANSA root directory
goto :exitError

:wrongVersion
@echo ERROR: The LANSA root dirctory is not the correct version (V11 SP4)
goto :exitError

:wrongEPClevel
@echo ERROR: The LANSA root dirctory is not the correct EPC level (%EPClvl%)
goto :exitError

:usage
@echo Usage: %0 
@echo.
@echo This command does not take any arguements

:exitError
@echo.
@echo This command assumes it is being run from a subdirectory under a valid LANSA
@echo root directory
@echo   For example:  "C:\Program Files\lansa\EPC800HF-070608"
@echo.
@echo This window will now close when you hit any key.
@echo You may [Ctrl-C] to exit script
@pause
exit /b 1

:theEnd

@rem now remove unused backup directories
for %%i in ( x_win95\x_lansa\execute x_win95\x_lansa\source lansa lansa\XSLEditor connect ) do (
  rmdir /q %LR%\%%i\%BUDIR% 2> NUL
)


@echo.
@echo This window will now close when you hit any key.
@echo You may [Ctrl-C] to exit script
@pause
